/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.enums.BOPClimates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;

public class ModCompatibility {
    public static void setup() {
        ModCompatibility.copyModBiomeWeights();
    }

    private static void copyModBiomeWeights() {
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            List moddedBiomesInType = BiomeManager.getBiomes((BiomeManager.BiomeType)type).stream().filter(biomeEntry -> !biomeEntry.getKey().func_240901_a_().func_110624_b().equals("minecraft")).collect(Collectors.toList());
            moddedBiomesInType.stream().forEach(biomeEntry -> ModCompatibility.remapBiomeToBoP((RegistryKey<Biome>)biomeEntry.getKey(), type, biomeEntry.field_76292_a));
        }
    }

    private static void remapBiomeToBoP(RegistryKey<Biome> biome, BiomeManager.BiomeType type, int weight) {
        for (BOPClimates climate : BOPClimates.values()) {
            ArrayList entries = Lists.newArrayList();
            entries.addAll(climate.getLandBiomes());
            entries.addAll(climate.getIslandBiomes());
            for (BOPClimates.WeightedBiomeEntry entry : entries) {
                if (entry.biome != biome) continue;
                return;
            }
        }
        for (BOPClimates climate : BOPClimates.values()) {
            if (climate.biomeType != type) continue;
            climate.addBiome(weight, biome);
        }
    }
}

