/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.IPlantable;

public class MahoganyTreeFeature
extends TreeFeatureBase {
    protected MahoganyTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    @Override
    protected boolean place(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, IWorld world, Random random, BlockPos pos, MutableBoundingBox boundingBox) {
        int height = random.nextInt(this.maxHeight - this.minHeight) + this.minHeight;
        boolean hasSpace = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.func_177956_o()) {
                    radius = 0;
                }
                if (y >= pos.func_177956_o() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius && hasSpace; ++x) {
                    for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.func_177977_b();
            Block soil = world.func_180495_p(soilPos).func_177230_c();
            boolean isSoil = soil.canSustainPlant(world.func_180495_p(soilPos), (IBlockReader)world, soilPos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.field_196674_t));
            if (this.placeOn.matches(world, soilPos) && isSoil && pos.func_177956_o() < 256 - height - 1) {
                soil.onPlantGrow(world.func_180495_p(soilPos), world, soilPos, pos);
                this.generateTrunk(changedLogs, changedLeaves, boundingBox, world, pos, height);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox, IWorld world, BlockPos start, int height) {
        int endHeight = height;
        for (int layer = 0; layer <= endHeight - 3; ++layer) {
            BlockPos middlePos = start.func_177981_b(layer);
            if (!this.replace.matches(world, middlePos)) continue;
            this.placeLog(world, middlePos, changedLogs, boundingBox);
        }
        BlockPos branchStartPos = start.func_177981_b(endHeight - 3);
        this.generateBranch(changedLogs, changedLeaves, boundingBox, world, branchStartPos, Direction.NORTH);
        this.generateBranch(changedLogs, changedLeaves, boundingBox, world, branchStartPos, Direction.EAST);
        this.generateBranch(changedLogs, changedLeaves, boundingBox, world, branchStartPos, Direction.SOUTH);
        this.generateBranch(changedLogs, changedLeaves, boundingBox, world, branchStartPos, Direction.WEST);
    }

    private void generateBranch(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox, IWorld world, BlockPos middle, Direction direction) {
        int z;
        int x;
        BlockPos pos = middle;
        int length = 1 + world.func_201674_k().nextInt(2);
        for (int i = 0; i <= length - 1; ++i) {
            if (!this.replace.matches(world, pos.func_177967_a(direction, i + 1))) continue;
            this.placeLog(world, pos.func_177967_a(direction, i + 1), direction.func_176740_k(), changedLogs, boundingBox);
        }
        int height = 1 + world.func_201674_k().nextInt(2);
        for (int i = 0; i <= height; ++i) {
            if (!this.replace.matches(world, pos.func_177967_a(direction, length + 1).func_177981_b(i + 1))) continue;
            this.placeLog(world, pos.func_177967_a(direction, length + 1).func_177981_b(i + 1), Direction.Axis.Y, changedLogs, boundingBox);
        }
        pos = pos.func_177967_a(direction, length + 1).func_177981_b(height + 2);
        int radius = 2;
        for (x = -(radius - 1); x <= radius - 1; ++x) {
            for (z = -(radius - 1); z <= radius - 1; ++z) {
                this.placeLeaves(world, pos.func_177982_a(x, 0, z), changedLeaves, boundingBox);
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                if (!(x != -radius && x != radius || z != -radius && z != radius)) continue;
                this.placeLeaves(world, pos.func_177982_a(x, -1, z), changedLeaves, boundingBox);
            }
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, MahoganyTreeFeature> {
        public Builder() {
            this.log = BOPBlocks.mahogany_log.func_176223_P();
            this.leaves = BOPBlocks.mahogany_leaves.func_176223_P();
            this.minHeight = 8;
            this.maxHeight = 14;
        }

        @Override
        public MahoganyTreeFeature create() {
            return new MahoganyTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

