/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BrambleBlock;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class BrambleFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery placeOn = (world, pos) -> {
        BlockState state = world.func_180495_p(pos);
        return state.canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.field_196674_t)) || state.func_177230_c() == Blocks.field_150424_aL;
    };
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).func_185904_a() == Material.field_151579_a;

    public BrambleFeature(Codec<NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos startPos, NoFeatureConfig config) {
        for (int i = 0; i < 128; ++i) {
            BlockPos genPos = startPos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.placeOn.matches((IWorld)world, genPos.func_177977_b()) || !this.replace.matches((IWorld)world, genPos)) continue;
            int targetLength = GeneratorUtil.nextIntBetween(rand, 15, 30);
            int height = 0;
            int direction = rand.nextInt(4) + 2;
            block5: for (int length = 0; length <= targetLength && this.replace.matches((IWorld)world, genPos); ++length) {
                world.func_180501_a(genPos, ((BrambleBlock)BOPBlocks.bramble).makeConnections((IBlockReader)world, genPos), 2);
                for (Direction face : Direction.values()) {
                    if (world.func_180495_p(genPos.func_177972_a(face)).func_177230_c() != BOPBlocks.bramble) continue;
                    world.func_180501_a(genPos.func_177972_a(face), ((BrambleBlock)BOPBlocks.bramble).makeConnections((IBlockReader)world, genPos.func_177972_a(face)), 2);
                }
                if (rand.nextInt(2) == 0) {
                    direction = rand.nextInt(4) + 2;
                }
                if (rand.nextInt(2) == 0) {
                    int leafDirection = rand.nextInt(6);
                    BlockPos leafPos = genPos.func_177972_a(Direction.values()[leafDirection]);
                    if (world.func_175623_d(leafPos)) {
                        world.func_180501_a(leafPos, (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 19);
                        for (Direction face : Direction.values()) {
                            if (world.func_180495_p(leafPos.func_177972_a(face)).func_177230_c() != BOPBlocks.bramble) continue;
                            world.func_180501_a(leafPos.func_177972_a(face), ((BrambleBlock)BOPBlocks.bramble).makeConnections((IBlockReader)world, leafPos.func_177972_a(face)), 2);
                        }
                    }
                }
                switch (rand.nextInt(6)) {
                    case 0: 
                    case 1: {
                        if (height > 8) continue block5;
                        genPos = genPos.func_177984_a();
                        ++height;
                        continue block5;
                    }
                    case 2: {
                        if (height < 0) continue block5;
                        genPos = genPos.func_177977_b();
                        --height;
                        continue block5;
                    }
                    default: {
                        genPos = genPos.func_177972_a(Direction.values()[direction]);
                    }
                }
            }
        }
        return true;
    }
}

