/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.world.BOPNetherLayerUtil;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;

public class BOPNetherBiomeProvider
extends BiomeProvider {
    public static final Codec<BOPNetherBiomeProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(biomeProvider -> biomeProvider.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(biomeProvider -> biomeProvider.biomes)).apply((Applicative)builder, builder.stable(BOPNetherBiomeProvider::new)));
    private static final List<RegistryKey<Biome>> VANILLA_POSSIBLE_BIOMES = ImmutableList.of((Object)Biomes.field_235254_j_, (Object)Biomes.field_235252_ay_, (Object)Biomes.field_235253_az_, (Object)Biomes.field_235250_aA_, (Object)Biomes.field_235251_aB_);
    private final long seed;
    private final Layer noiseBiomeLayer;
    private final Registry<Biome> biomes;

    public BOPNetherBiomeProvider(long seed, Registry<Biome> biomes) {
        super(Stream.concat(VANILLA_POSSIBLE_BIOMES.stream(), BOPClimates.NETHER.getLandBiomes().stream().map(entry -> entry.biome)).map(arg_0 -> biomes.func_230516_a_(arg_0)).collect(Collectors.toList()));
        this.seed = seed;
        this.noiseBiomeLayer = BOPNetherLayerUtil.createGenLayers(seed);
        this.biomes = biomes;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new BOPNetherBiomeProvider(seed, this.biomes);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.noiseBiomeLayer.func_242936_a(this.biomes, x, z);
    }
}

