/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<aqe, cck> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(aqe entityType, String name, float shadowSize) {
        this(Either.makeLeft(entityType), name, shadowSize, null);
    }

    public ModelAdapter(aqe entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft(entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(cck tileEntityType, String name, float shadowSize) {
        this(Either.makeRight(tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(Either<aqe, cck> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<aqe, cck> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract duv makeModel();

    public abstract dwn getModelRenderer(duv var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(duv var1, float var2);

    public dwn[] getModelRenderers(duv model) {
        String[] names = this.getModelRendererNames();
        ArrayList<dwn> list = new ArrayList<dwn>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            dwn mr2 = this.getModelRenderer(model, name);
            if (mr2 == null) continue;
            list.add(mr2);
        }
        dwn[] mrs = list.toArray(new dwn[list.size()]);
        return mrs;
    }
}

